using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using System.Data;
using IndianHealthService.BMXNet.Model;
using IndianHealthService.BMXNet.WinForm.Configuration;
using IndianHealthService.BMXNet.WinForm;
using System.Threading;

namespace IndianHealthService.BMXNet.Tests
{

    /// <summary>
    /// BMX ADO SS^BMX TEST FILE^^~~~~~
    /// 
    /// </summary>
    /// 

    public abstract class BmxBaseTestSuite
    {

        public void Hang(int aNumberOfSeconds)
        {
            Thread.Sleep(aNumberOfSeconds * 1000);
        }

        private TestUser _user = null;

        public TestUser User
        {
            get { return _user; }
            set { _user = value; }
        }


        private WinFramework _framework = null;

        public WinFramework Framework
        {
            get { return _framework; }
            set { _framework = value; }
        }
        private LoginProcess _loginProcess = null;

        public LoginProcess LoginProcess
        {
            get { return _loginProcess; }
            set { _loginProcess = value; }
        }
        private RpmsConnectionSpec _connectionSpec = null;

        public RpmsConnectionSpec ConnectionSpec
        {
            get { return _connectionSpec; }
            set { _connectionSpec = value; }
        }

        private RemoteSession _remoteSession = null;

        public RemoteSession RemoteSession
        {
            get { return _remoteSession; }
            set { _remoteSession = value; }
        }



        public RemoteSession OpenConnection(TestUser aUser)
        {
            this.Framework = new WinFramework();
            this.LoginProcess = this.Framework.CreateLoginProcess();

            if (aUser.Login(this.LoginProcess))
            {
                this.RemoteSession = this.Framework.PrimaryRemoteSession;
            }
            return this.RemoteSession;
        }

        [TearDown]
        public void CloseFramework()
        {
            if (this.Framework != null)
            {
                this.Framework.Close();
                this.Framework = null;
            }
            this.LoginProcess = null;
            this.RemoteSession = null;
        }

        protected String _fetchTableString = "BMX ADO SS^BMX TEST FILE^^~~~~~";

        public String FetchTableString
        {
            get { return _fetchTableString; }
            set { _fetchTableString = value; }
        }

        [SetUp]
        public virtual void Setup()
        {
            this.SetupConnection();
        }

        public abstract void SetupTestUser();

        public virtual void SetupConnection()
        {
            this.SetupTestUser();
            this.OpenConnection(this.User);
        }

        public virtual void SetupTable()
        {

        }

        public virtual void ClearTable()
        {
            DataTable table = this.RemoteSession.TableFromCommand(this.FetchTableString);
           
            foreach (DataRow each in table.Rows)
            {
                each.Delete();
            }
            this.RemoteSession.SaveChanges(table);

            table = this.RemoteSession.TableFromCommand(this.FetchTableString);
            Assert.AreEqual(0, table.Rows.Count);
        }



    }
}